IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPU_Cbtes_Mora_Generar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPU_Cbtes_Mora_Generar]
END
GO

CREATE  PROCEDURE [dbo].[CPU_Cbtes_Mora_Generar]
@Id_Cliente		INT, 
@Importe		DECIMAL(12,2), 
@Fecha			DATETIME, 
@Id_Tipo_Cbte	CHAR(4),
@Lote			CHAR(14),
@Id_Estado_Cbte INT,
@Cant			INT,
@ALIAS_CS       INT,
@IMPORTE_CS     DECIMAL(12,2), 
@ALIAS_varios   INT,
@IMPORTE_VARIOS DECIMAL(12,2),
@CORTE          SMALLINT,
@FECHA_CORTE    DATETIME,
@Id_Tipo_Cbte_Fut CHAR(4),
@AgrupaDeuda	TINYINT



AS 
SET NOCOUNT ON 
DECLARE @Mensaje				VARCHAR(100)
DECLARE @Id_Moneda				CHAR(3)
DECLARE @Id_Iva					CHAR(3)
DECLARE @Id_Cond_Pago			SMALLINT
DECLARE @Id_Producto			CHAR(14)
DECLARE @Sql					NVARCHAR(1000) 
DECLARE @CuentasCuotaSocial		NVARCHAR(1000) 


/***************************************************************************************************/
----Comentar
--SET @Mensaje = 'Debe configurar el proceso CPU_Cbtes_Mora_Generar.'
--SELECT	 9999				AS ErrorNumber 
--		,0					AS ErrorSeverity  
--		,0					AS ErrorState 
--		,0					AS ErrorProcedure  
--		,0					AS ErrorLine		
--		,@Mensaje			AS ErrorMessage

--RETURN 1   

----comentar hasta aca
--/****************************************************************************************************/
--Parametrizar


SET @Id_Moneda				= 'PES'
SET @Id_Iva					= 'CF'
SET @Id_Cond_Pago			= 10
SET @Id_Producto			= ''

--Configurar aca las cuentas correspondientes a cuota social  (alias)
SET @CuentasCuotaSocial		= '182,183,184,185,186,187,188,189,190'





/*******************************fin configuracion del la instalacion************************************/

BEGIN TRAN
BEGIN TRY

PRINT 'Genero Comprobante Tipo: '+@Id_Tipo_Cbte+' para el Cliente: '+CONVERT(VARCHAR(20),@Id_Cliente)
PRINT 'Fecha del Comprobante: '+CONVERT(VARCHAR(20), @Fecha, 101)+' Estado Comprobante: '+CONVERT(VARCHAR(3),@id_Estado_Cbte)

/*Declaracion Variables Locales*/
DECLARE @Trans_Nueva			INT
DECLARE @Nro_Cbte				INT
DECLARE @Suc					INT
DECLARE @User					SMALLINT
DECLARE @Compromete_Factura		SMALLINT
DECLARE @Compromete_Recibo		SMALLINT
DECLARE @Compromete_Remito		SMALLINT
DECLARE @Compromete_Asientos    SMALLINT
DECLARE @Desc					VARCHAR(50)
DECLARE @Nombre					VARCHAR(100)
DECLARE @Descripcion_Producto	VARCHAR(100)
DECLARE @Cantidad				DECIMAL(12,2)
DECLARE @Fecha_Mov				DATETIME
DECLARE @Descrip_Cbte_CtaCte	VARCHAR(100)
DECLARE @Signo					INT
DECLARE @ImporteXCant			DECIMAL(12,2)
DECLARE	@Observacion			VARCHAR(30)
DECLARE @ID_CTA_CS              INT
DECLARE @ID_CTA_VARIOS          INT

/*FIN Declaracion Variables Locales*/

/*Asignacion Variables*/
SET @Descripcion_Producto	= (SELECT Descripcion_Resumida		FROM Productos	 WHERE Id_Producto  = @Id_Producto)
SET @Nombre					= (SELECT RTRIM(Razon_Social)		FROM Clientes	 WHERE Id_Cliente	= @Id_Cliente)

SET @Trans_Nueva			= ISNULL((SELECT (MAX(id_trans)+1)	FROM Transacciones),1)
SET @Desc					= @Lote
SET @Observacion			= 'Comprobante Generado desde Baja por Mora'

Set @ID_CTA_CS              =  DBO.CF_Cta_Cont(@ALIAS_CS,@fecha)
Set @ID_CTA_VARIOS          =  DBO.CF_Cta_Cont(@ALIAS_varios,@fecha)
 
/*FIN Asignacion Variables*/

SET @Signo = 1

IF((@Compromete_Recibo = 1) OR (@Compromete_Factura = -1))
BEGIN
	SET @Signo = -1
END

/*---------------------------------------------------------------------------------*/

/*Insert: TRANSACCIONES*/
PRINT 'Inserto la Transaccion Nro: ' + CONVERT(VARCHAR(20), @Trans_Nueva)

INSERT INTO Transacciones	(Id_Trans,		Descripcion,	Fecha_Mov) 
VALUES						(@Trans_Nueva,	@Desc,			GETDATE())


/*FIN Insert: TRANSACCIONES*/

/*---------------------------------------------------------------------------------*/

/*Leo: CBTES_Tipos*/
SELECT	@Compromete_Remito		= ISNULL(Compromete_Remitos,0) 
		,@Compromete_Asientos	= ISNULL(Compromete_Asientos,0)	
		,@Compromete_Factura	= ISNULL(Compromete_Factura,0)	
		,@Compromete_Recibo		= ISNULL(Compromete_Recibos,0)
		,@Nro_Cbte				= ISNULL(Prox_Nro,1)	
		,@Suc					= ISNULL(Id_Sucursal,0)
		FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte

/*Actualizo el Proximo Numero de Comprobante*/
PRINT 'Actualizo el Proximo Nro de Comprobante Tipo: '+@Id_Tipo_Cbte+' a: ' + CONVERT(VARCHAR(20), (@Nro_Cbte + 1))

UPDATE Cbtes_Tipos SET Prox_Nro = (@Nro_Cbte + 1) WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
/*FIN Actualizo el Proximo Numero de Comprobante*/


/*Insert: CBTES*/
SET @ImporteXCant = (@Importe * @Cant)

PRINT 'Inserto en Cbtes'
INSERT INTO Cbtes			(Id_Trans,			Id_Sucursal,		Id_Tipo_Cbte,
							Cbte_Grupo,			Comprobante_Nro,	Id_Cliente,
							Id_Proveedor,		Signo,				Id_Estado_Cbte,
							Fecha,				Porc_DescEspecial,	Imp_Bonificacion,
							Imp_Gravado,		Imp_Exento,			Imp_IVA,
							Imp_IVA2,			Imp_Percepcion_IB,	Imp_Percepcion_Iva,
							Imp_Total,			Id_Usuario,			Porc_Iva3,
							Imp_Gravado2,		Imp_Gravado3,		Imp_NoGravado,
							Imp_IVA3,			Imp_Percep,			Saldo,
							Periodo_Iva,		Periodo,			Fecha_Venc,
							Observacion,		Id_Cond_Pago,		Cant_Cuotas,
							Cantidad,			Id_Lista,			Id_Moneda,
							Cotizacion,			Destinatario,		Id_Iva,
							Saldo_Iva_Recup,	Lote,				Id_Asiento,
							Id_Valor,			Cai,				Cantidad_Saldo,
							Saldo_Anterior,		Porc_DescFin,		Porc_Bonificacion,
							Porc_Iva,			Porc_Iva2,			Imp_Neto,
							Imp_DescEspecial,	Imp_DescFin)
VALUES						(@Trans_Nueva,		@Suc,				@Id_Tipo_cbte,
							0/*Cbte_Grupo*/,	@Nro_Cbte,			@Id_Cliente,
							0/*Id_Proveedor*/,	0/*Signo*/,			@Id_Estado_Cbte,
							@Fecha,				0/*Porc_DescEspec*/,0/*Imp_Bonificacion*/,
							0/*Imp_Gravado*/,	@ImporteXCant,		0/*Imp_Iva*/,
							0/*Imp_Iva2*/,		0/*Imp_Percepcion_*/,0/*Imp_Percepcion_Iva*/,
							@ImporteXCant,		0/*Id_Usuario*/,	
							CAST( dbo.CF_xParam('Tasa_Iva_3')   AS DECIMAL(5,2))/*Porc_Iva3*/,
							0/*Imp_Gravado2*/,	0/*Imp_Gravado3*/,	0/*Imp_NoGravado*/,
							0/*Imp_IVA3*/,		0/*Imp_Percep*/,	@ImporteXCant,
							@Fecha,				@Fecha,				@Fecha,
							@Observacion,		@Id_Cond_Pago,		1/*Cant_Cuotas*/,
							0/*Cantidad*/,		0/*Id_Lista*/,		@Id_Moneda  /*Id_Moneda*/,
							1/*Cotizacion*/,	@Nombre,			@Id_Iva/*Id_Iva*/,
							0/*Saldo_Iva_Recu*/,@Lote,				0/*Id_Asiento*/,
							0/*Id_Valor*/,		0/*Cai*/,			0/*Cantidad_Saldo*/,
							0/*Saldo_Anterior*/,0/*Porc_DescFin*/,	0/*Porc_Bonificacion*/,
							CAST( dbo.CF_xParam('Tasa_Iva_1')   AS DECIMAL(5,2))/*Porc_Iva*/,		
							CAST( dbo.CF_xParam('Tasa_Iva_2')   AS DECIMAL(5,2))/*Porc_Iva2*/
							,@ImporteXCant,
							0/*Imp_DescEspecial*/,0/*Imp_DescFin*/)
							
/*FIN Insert: CBTES*/


/*---------------------------------------------------------------------------------*/

/*Insert: CBTES_ITEMS*/
PRINT 'Inserto en Cbtes_Items'
INSERT INTO Cbtes_Items		(Id_Cliente,	Descripcion_producto,	Cantidad,
							Id_Estado_Cbte,	Cantidad_Saldo,			Id_Trans,
							Item,			Precio_Grav,			Imp_Gravado,
							Imp_Final,		Precio,					Lote,
							Fecha_QA,		Flag_QA,				Id_Producto,
							Imp_Exento,		Porc_Iva,				Bonif,
							Id_Usuario)
VALUES						(@Id_Cliente,	RTRIM(@Descripcion_Producto),@Cant,
							@Id_Estado_Cbte,@Cant,					@trans_nueva,
							1,				@Importe,				(@Importe * @Cant),
							(@Importe * @Cant),@Importe,			@Lote,
							@Fecha,			'A',					@Id_Producto,
							0,				0,						0,
							0)
        
/*FIN Insert: CBTES_ITEMS*/

/*---------------------------------------------------------------------------------*/

/*Si el comprobante no es Remito, debe llevar Cta Cte y Cta Contable*/
IF (@Compromete_Remito = 0) 
BEGIN
	PRINT 'NO es Remito, Genero CtaCte y CtaContable'
	
	/*Insert: Clientes_CtaCte*/	
	IF @Id_Cond_Pago <> 1
	BEGIN
		SET @Descrip_Cbte_CtaCte   = dbo.CF_Cbte_Descrip(@trans_nueva)


		PRINT 'Inserto en Clientes_CtaCte Comprobante: ' + @Descrip_Cbte_CtaCte
								
		INSERT INTO Clientes_CtaCte		(Id_Trans,			Nro_Cuota,				Id_Empresa,
										Id_Cliente,			Fecha,					Fecha_Vence,
										Descripcion,		Importe,				Id_Estado_Cbte,
										Observacion,		Id_Trans_Origen,		Nro_Cuota_Origen,
										Id_Moneda,			Saldo,					Nro_FacCre)
		VALUES							(@trans_nueva,		1,						NULL,
										@id_cliente,		@Fecha,					@Fecha,
										@Descrip_Cbte_CtaCte,((@Importe * @Cant)*@Signo),	@Id_Estado_Cbte,
										@Observacion,		0,						0,
										@Id_Moneda,				((@Importe * @Cant)*@Signo),	0)
	END

	--genero cuentas contables

	IF @Compromete_Asientos <> 0
	BEGIN
	    SELECT * INTO #cuentas FROM Cbtes_Ctas_Contables WHERE 1=0
		alter table #cuentas add z_aplicado decimal(17,5)

		SET @Sql = 'INSERT INTO #cuentas
						select k.*,(c.Saldo / c.Imp_Total) as z_aplicado  
						from cbtes c, Cbtes_Ctas_Contables k, CLIENTES A , Cbtes_Tipos T
						where c.id_trans = K.ID_TRANS 
								AND C.ID_CLIENTE = A.ID_CLIENTE 
								AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte
								AND (T.Compromete_Factura IN (1,-1) OR T.Compromete_Recibos IN (1,-1))
								AND c.Id_Estado_Cbte IN (1,4)
								AND c.Lote <> '''+ LTRIM(RTRIM(@Lote)) +'''
								and c.saldo <> 0
								and (k.debe <> 0 OR k.Haber <> 0)' 

        IF ISNULL(@AgrupaDeuda,0) = 0
		   SET @Sql = LTRIM(RTRIM(@Sql)) + ' AND A.ID_CLIENTE = '+ CAST(@Id_Cliente AS VARCHAR(10))
		ELSE
		   SET @Sql = LTRIM(RTRIM(@Sql)) + ' AND (A.ID_CLIENTE = '+ CAST(@Id_Cliente AS VARCHAR(10)) +' OR A.Id_Cliente_Ref = '+ CAST(@Id_Cliente AS VARCHAR(10)) + ')'


		IF @CORTE = 1
			SET @Sql = LTRIM(RTRIM(@Sql)) + ' AND C.FECHA < '''+ CONVERT(CHAR(8),@Fecha_CORTE,112) + ''''

		IF @CORTE = 2
			SET @Sql = LTRIM(RTRIM(@Sql)) + ' AND C.FECHA >=  '''+ CONVERT(CHAR(8),@Fecha_CORTE,112) + ''''


		
		EXEC sp_executesql @Sql  

		alter table #cuentas add z_importe decimal(12,2)
		alter table #cuentas add z_renglon int identity(1,1)

		update #cuentas set  observacion = id_trans,  item = z_renglon
		update #cuentas set  id_trans = @trans_nueva, Fecha = @fecha
		update #cuentas set  z_importe = debe  * z_aplicado
		update #cuentas set  debe = haber  * z_aplicado
		update #cuentas set  haber = z_importe
		update #cuentas set  Id_Cta_Contable = DBO.CF_Cta_Cont(Alias,@fecha) where debe = 0

		SET @Sql = 'update #cuentas set alias = '+ CAST(@ALIAS_CS as VARCHAR(10)) +
						', Id_Cta_Contable = '+ CAST(@ID_CTA_CS  as VARCHAR(10)) +
						' where alias in ('+ @CuentasCuotaSocial +') and haber = 0'
		EXEC sp_executesql @Sql  


		SET @Sql = 'update #cuentas set alias = '+ CAST(@ALIAS_varios as VARCHAR(10)) +
					', Id_Cta_Contable = '+ CAST(@ID_CTA_VARIOS as VARCHAR(10)) +
					' where alias not in ('+ LTRIM(RTRIM(@CuentasCuotaSocial)) +') 
					     AND alias <> '+ CAST(@ALIAS_CS as VARCHAR(10)) +
					    ' and haber = 0'
		EXEC sp_executesql @Sql  

		Alter table #cuentas drop column z_importe, z_renglon, z_aplicado
		Insert into Cbtes_Ctas_Contables  select * from #cuentas
		Drop table #cuentas
	END  --IF @Compromete_Asientos <> 0


	IF @CORTE = 0 OR @CORTE = 2
	   BEGIN
	       DECLARE @Id_TRANS_PROC INT
		   DECLARE @ID_TRANS_ORIGEN INT

	       SELECT C.* INTO #CBTES_AUX FROM CBTES C, CBTES_TIPOS T
		                          WHERE C.FECHA > @Fecha AND C.ID_TIPO_CBTE = T.ID_TIPO_CBTE AND C.ID_ESTADO_CBTE IN (1) 
	                                    AND C.ID_CLIENTE = @ID_CLIENTE AND C.SALDO <> 0 AND T.COMPROMETE_FACTURA IN (1,-1)
										AND C.SALDO = C.IMP_TOTAL
           SELECT I.* INTO #CBTES_ITEMS_AUX  FROM CBTES_ITEMS I, #CBTES_AUX C WHERE I.ID_TRANS = C.ID_TRANS
		   SELECT I.* INTO #CLIENTES_CTACTE_AUX FROM CLIENTES_CTACTE I, #CBTES_AUX C WHERE I.ID_TRANS = C.ID_TRANS
		   SELECT I.* INTO #CBTES_CTAS_CONTABLES_AUX  FROM CBTES_CTAS_CONTABLES I, #CBTES_AUX C WHERE I.ID_TRANS = C.ID_TRANS

		   SELECT ID_TRANS,0 AS ID_TRANS_ORIGEN  INTO #PROCESAR FROM #CBTES_AUX

		   DECLARE CUR_GENERAR CURSOR FOR

		   SELECT * FROM #PROCESAR

		   OPEN CUR_GENERAR
		   FETCH NEXT FROM CUR_GENERAR INTO  @Id_TRANS_PROC,@ID_TRANS_ORIGEN
		   WHILE @@FETCH_STATUS = 0
		      BEGIN
			      SET @Trans_Nueva			= ISNULL((SELECT (MAX(id_trans)+1)	FROM Transacciones),1)
				  INSERT INTO Transacciones	(Id_Trans,		Descripcion,	Fecha_Mov) 
						 VALUES				(@Trans_Nueva,	@Desc,			GETDATE())
	
				  SELECT	@Compromete_Remito		= ISNULL(Compromete_Remitos,0) 
							,@Compromete_Asientos	= ISNULL(Compromete_Asientos,0)	
							,@Compromete_Factura	= ISNULL(Compromete_Factura,0)	
							,@Compromete_Recibo		= ISNULL(Compromete_Recibos,0)
							,@Nro_Cbte				= ISNULL(Prox_Nro,1)	
							,@Suc					= ISNULL(Id_Sucursal,0)
							FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte_Fut


				  UPDATE #PROCESAR SET ID_TRANS_ORIGEN = @Trans_Nueva WHERE ID_TRANS = @Id_TRANS_PROC

				  UPDATE Cbtes_Tipos SET Prox_Nro = (@Nro_Cbte + 1) WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte_Fut

				  UPDATE #CBTES_AUX SET Id_Trans_Origen = ID_TRANS, ID_TRANS = @Trans_Nueva, Id_Tipo_Cbte = @Id_Tipo_Cbte_Fut, Comprobante_Nro = @Nro_Cbte 
				   WHERE ID_TRANS = @Id_TRANS_PROC
				  UPDATE #CBTES_ITEMS_AUX SET ID_TRANS = @Trans_Nueva WHERE ID_TRANS = @Id_TRANS_PROC
				  UPDATE #CBTES_CTAS_CONTABLES_AUX SET ID_TRANS = @Trans_Nueva WHERE ID_TRANS = @Id_TRANS_PROC
				  UPDATE #CLIENTES_CTACTE_AUX SET ID_TRANS = @Trans_Nueva, Importe = Importe *-1, Saldo = Saldo*-1  WHERE ID_TRANS = @Id_TRANS_PROC

			  FETCH NEXT FROM CUR_GENERAR INTO  @Id_TRANS_PROC,@ID_TRANS_ORIGEN
	  
	       END

		   INSERT INTO CBTES 
		          SELECT * FROM #CBTES_AUX
		   INSERT INTO CBTES_ITEMS
		          SELECT * FROM #CBTES_ITEMS_AUX
		   INSERT INTO CLIENTES_CTACTE 
		          SELECT * FROM #CLIENTES_CTACTE_AUX

           -- INVIERTO CTAS CONTABLES

			alter table #CBTES_CTAS_CONTABLES_AUX add z_importe decimal(12,2)

			update #CBTES_CTAS_CONTABLES_AUX set  z_importe = debe  
			update #CBTES_CTAS_CONTABLES_AUX set  debe = haber 
			update #CBTES_CTAS_CONTABLES_AUX set  haber = z_importe


			Alter table #CBTES_CTAS_CONTABLES_AUX drop column z_importe
			Insert into Cbtes_Ctas_Contables  select * from #CBTES_CTAS_CONTABLES_AUX

	 	    CLOSE CUR_GENERAR
		    DEALLOCATE CUR_GENERAR

			UPDATE CLIENTES_CTACTE SET DESCRIPCION = dbo.CF_Cbte_Descrip(ID_TRANS)  WHERE ID_TRANS IN (SELECT ID_TRANS_ORIGEN FROM #PROCESAR)

		    DROP TABLE #PROCESAR
		    DROP TABLE #CBTES_AUX
		    DROP TABLE #CBTES_ITEMS_AUX
		    DROP TABLE #CBTES_CTAS_CONTABLES_AUX
		    DROP TABLE #CLIENTES_CTACTE_AUX

 

	END -- GENERAR CBTES FUTUROS

END  --IF (@Compromete_Remito = 0) 


SET @Mensaje = 'Transaccion Generada Nro: '+ CAST(@trans_nueva AS VARCHAR(10))

COMMIT
SELECT	 0					AS ErrorNumber 
		,0					AS ErrorSeverity  
		,0					AS ErrorState 
		,0					AS ErrorProcedure  
		,@trans_nueva		AS ErrorLine		
		,@Mensaje			AS ErrorMessage

RETURN 0
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
	RETURN 1
END CATCH;  
